	.include	'eq.s'
	.include	'externs.s'

	.text

move_en::
	clr.w	d6					;count enemies
	lea		enemy0,a1				;first enemy
	lea		en_speed,a2
	lea		en_mvcnt,a3
	lea		en_mvlmt,a4
	lea		en_type,a5
.10:
	tst.b	O_TYPE(a1)			;see if enemy is active
	bmi.b	.80					;if not active, try the next enemy

	move.w	(a5),d0				;get enemy type
	lsl.w	#2,d0
	lea		en_mvadr,a0
	move.l	(a0,d0.w),a0
	jsr		(a0)					;do enemy movement subroutine
.80:
	adda.l	#OBJ_SIZE,a1			;next object header
	adda.l	#2,a5				;next en_type
	addq.w	#1,d6
	cmp.w	#TOTAL_ENEMIES,d6
	blt		.10					;count enemies
	rts


no_move::
;for any enemy objects that do not need to be moved by move_en
	rts

m_tomag::
	lea		en_usept,a0
	clr.b	(a0,d6.w)				;don't use pattern after position is affected by magnet
	move.l	#(MAGNET_PULL*32),d0	;speed to move toward magnet * 16 directions for each speed * 2 bytes for each direction
	clr.l	d1
	lea		dirtomag,a0
	move.b	(a0,d6.w),d1			;get direction to magnet
	cmp.w	#0,scrlspd
	beq.b	.50					;if scrolling has stopped, no adjustment needed
	cmp.b	#8,d1				;see if direction is straight to the right
	bge.b	.50					;if down or right, no adjustment needed
	cmp.b	#0,d1
	beq.b	.50					;if straight up, no adjustment needed
	add.w	#64,d0				;increase speed 2 levels to make up for background scrolling if enemy is moving to the right
.50:	add.w	d1,d0				;add direction to speed * 32
	add.w	d1,d0				;add direction again because each direction uses 2 bytes
	bsr		move_obj
	tst.b	limitflag
	beq.b	.90					;did not reach limit if 0
	tst.w	O_DESC(a1)
	bmi		en_off				;turn off explosion when it reaches limit

	bsr		get_dir
	clr.b	(a3,d6.w)				;reset en_mvcnt when direction changes

.90:	rts

m_usept::
;move enemy according to formula
;D6 = enemy number
	lea		en_formc,a6			;counter for moves in pattern
	move.w	d6,d2				;can't change d6
	lsl.w	#1,d2				;enemy number * 2
	move.w	(a6,d2.w),d3			;get en_formc
	add.w	#1,d3				;add 1 to en_formc
	lea		en_frmlm,a0
	cmp.w	(a0,d2.w),d3			;compare limit to counter
	blt.b	.20
	clr.w	d3					;reset pattern moves counter
.20:	move.w	d3,(a6,d2.w)			;save new en_formc value
	lea		en_rad,a0
	move.w	(a0,d2.w),d4			;set radius in D4
	lea		en_theta,a0
	move.w	(a0,d2.w),d5			;set theta in D5
	lea		en_formx,a0
	move.w	(a0,d2.w),d1			;set en_formx in D1
	lea		en_formy,a0
	move.w	(a0,d2.w),d2			;set en_formy in D2
	bsr		do_wave				;must have D1-D5 set
	rts

m_useptb::
;move enemy according to formula
;make en_formc count backwards
;D6 = enemy number
	lea		en_formc,a6			;counter for moves in pattern
	move.w	d6,d2				;can't change d6
	lsl.w	#1,d2				;enemy number * 2
	move.w	(a6,d2.w),d3			;get en_formc
	sub.w	#1,d3				;subtract 1 from en_formc
	bpl.b	.20
	lea		en_frmlm,a0
	move.w	(a0,d2.w),d3			;get limit for counter
	subq.w	#1,d3
.20:	move.w	d3,(a6,d2.w)			;save new en_formc value
	lea		en_rad,a0
	move.w	(a0,d2.w),d4			;set radius in D4
	lea		en_theta,a0
	move.w	(a0,d2.w),d5			;set theta in D5
	lea		en_formx,a0
	move.w	(a0,d2.w),d1			;set en_formx in D1
	lea		en_formy,a0
	move.w	(a0,d2.w),d2			;set en_formy in D2
	bsr		do_wave				;must have D1-D5 set
	rts


m_wback::
;this moves an enemy object to the left at the background scrolling speed
;object does not move if game is over
;object does not go toward magnet
;d6 = enemy counter
;a1 = enemy object header
;a2 = en_speed
;a3 = en_mvcnt
;a4 = en_mvlmt
;a5 = en_type

	tst.b	gameover
	bne.b	.80					;don't move object if game is over

	move.w	d6,d0				;get enemy number
	lsl.w	#3,d0				;enemy number * 8 (limit table has 8 bytes for each enemy)
	lea		en_lim,a0
	move.w	(a0,d0.w),d2			;left limit (always negative)

	move.w	O_XPOS(a1),d0			;get object xpos
	sub.w	scrlspd,d0			;subtract background scrolling speed
	cmp.w	d2,d0
	bge.b	.20					;if xpos > a negative left limit, move is ok
	cmp.w	#$F000,d0
	bge.b	.50
.20:	move.w	d0,O_XPOS(a1)
	bra.b	.80
.50:
	lea		en_lf_lim,a0
	move.w	(a5),d0
	cmp.b	#1,(a0,d0.w)
	beq		en_off				;turn off enemy if it reached its left limit

.80:	rts

m_left::
;this moves an enemy object to the left at the background scrolling speed + its en_speed
;object does move if game is over
;d6 = enemy counter
;a1 = enemy object header
;a2 = en_speed
;a3 = en_mvcnt
;a4 = en_mvlmt
;a5 = en_type

	move.w	d6,d0				;get enemy number
	lsl.w	#3,d0				;enemy number * 8 (limit table has 8 bytes for each enemy)
	lea		en_lim,a0
	move.w	(a0,d0.w),d2			;left limit

	cmp.w	#FIRST_BOSS_ENEMY,(a5)
	bge.b	.10					;don't move ground enemies or boss enemies toward magnet
	tst.b	specweap+O_TYPE
	bmi.b	.10
	cmp.w	#MAGNET,specweap+O_DESC
	beq		m_tomag
	bra.b	.80
.10:
	clr.l	d0
	move.b	(a2,d6.w),d0			;speed of enemy
.20:
	move.w	O_XPOS(a1),d1			;get object xpos
	sub.w	scrlspd,d1			;subtract background scrolling speed
	sub.w	d0,d1				;subtract enemy speed
	cmp.w	d2,d1
	bge.b	.30					;if xpos > a negative left limit, move is ok
	cmp.w	#$F000,d1
	bge.b	.40
.30:	move.w	d1,O_XPOS(a1)
	bra.b	.80
.40:
	lea		en_lf_lim,a0
	move.w	(a5),d0
	cmp.b	#1,(a0,d0.w)
	beq		en_off				;turn off enemy if it reached its left limit

.80:	rts

m_fallrk:
;d6 = enemy counter
;a1 = enemy object header
;a2 = en_speed
;a3 = en_mvcnt
;a4 = en_mvlmt
;a5 = en_type
	move.w	O_XPOS(a1),d0
	bmi.b	.10					;ignore if off left side of screen
	lea		enemydir,a6
	cmp.b	#8,(a6,d6.w)			;see if direction is down
	beq.b	.10
	cmp.w	#250,d0
	bge.b	.10
	cmp.b	#30,seed+3
	bge.b	.10
	move.b	#8,(a6,d6.w)			;fall straight down
.10:
	sub.w	scrlspdf,d0			;subtract foreground scrolling speed
	cmp.w	#-48,d0
	bge.b	.30					;if xpos > a negative left limit, move is ok
	cmp.w	#$8000,d0
	bge		en_off				;turn off falling rock if it goes off left side of screen
.30:	move.w	d0,O_XPOS(a1)
	cmp.b	#8,(a6,d6.w)			;see if direction is down
	bne.b	.90
	clr.w	d0
	move.b	(a2,d6.w),d0
	add.w	d0,O_YPOS(a1)			;move down if rock is falling
	cmp.w	#SCRN_BOTTOM,O_YPOS(a1)
	bge		en_off				;turn it off if it goes off the bottom of the screen
.90:	rts

m_poppy:
;d6 = enemy counter
;a1 = enemy object header
;a2 = en_speed
;a3 = en_mvcnt
;a4 = en_mvlmt
;a5 = en_type
	move.w	O_XPOS(a1),d0
	bmi.b	.10					;ignore if off left side of screen
	lea		enemydir,a6
	cmp.b	#0,(a6,d6.w)			;see if direction is up
	beq.b	.10
	cmp.w	#180,d0
	bge.b	.10
	cmp.b	#3,seed+3				;chance of floating up
	bge.b	.10
	move.b	#0,(a6,d6.w)			;float straight up
.10:
	sub.w	scrlspd,d0			;subtract background scrolling speed
	cmp.w	#-32,d0
	bge.b	.30					;if xpos > a negative left limit, move is ok
	cmp.w	#$F000,d0
	bge		en_off				;turn off poppy if it goes off left side of screen
.30:	move.w	d0,O_XPOS(a1)
	cmp.b	#0,(a6,d6.w)			;see if direction is up
	bne.b	.90
	clr.w	d0
	move.b	(a2,d6.w),d0
	sub.w	d0,O_YPOS(a1)			;move up if poppy is floating
	cmp.w	#-114,O_YPOS(a1)
	bge.b	.90
	cmp.w	#$8000,O_YPOS(a1)
	bge		en_off				;turn off poppy if it goes off top of screen
.90:	rts

m_rat::
m_vult::
;d6 = enemy counter
;a1 = enemy object header
;a2 = en_speed
;a3 = en_mvcnt
;a4 = en_mvlmt
;a5 = en_type

	tst.b	gameover				;game not over if 0
	beq.b	.30
	lea		en_usept,a0
	clr.b	(a0,d6.w)
	sub.w	#3,O_XPOS(a1)
	bpl.b	.90
	cmp.w	#-64,O_XPOS(a1)
	bge.b	.90
	bra		en_off				;turn off enemy if it reached its left limit
.30:
	tst.b	specweap+O_TYPE
	bmi.b	.50
	cmp.w	#MAGNET,specweap+O_DESC
	beq		m_tomag
.50:
	lea		en_usept,a0
	cmp.b	#1,(a0,d6.w)
	bne		m_normal
	lea		in_form,a0
	cmp.b	#$FF,(a0,d6.w)
	bne		m_normal

	lea		en_formx,a0
	move.w	d6,d2				;can't change d6
	lsl.w	#1,d2				;enemy number * 2
	move.w	(a0,d2.w),d3			;get current en_formx
	cmp.w	#(SCRN_RIGHT/2),d3		;compare to middle of screen
	blt.b	.60
	clr.w	d0
	move.b	(a2,d6.w),d0			;get enemy speed
	sub.w	d0,d3				;move left
.60:	move.w	d3,(a0,d2.w)			;save new en_formx value
	bsr		m_useptb
	move.w	d1,O_XPOS(a1)
	move.w	d2,O_YPOS(a1)
.90:	rts

m_fbug::
;d6 = enemy counter
;a1 = enemy object header
;a2 = en_speed
;a3 = en_mvcnt
;a4 = en_mvlmt
;a5 = en_type

	tst.b	gameover				;game not over if 0
	beq.b	.30
	lea		en_usept,a0
	clr.b	(a0,d6.w)
	sub.w	#3,O_XPOS(a1)
	bpl		.90
	cmp.w	#-64,O_XPOS(a1)
	bge		.90
	bra		en_off				;turn off enemy if it reached its left limit
.30:
	tst.b	specweap+O_TYPE
	bmi.b	.50
	cmp.w	#MAGNET,specweap+O_DESC
	beq		m_tomag
.50:
	lea		en_usept,a0
	cmp.b	#1,(a0,d6.w)
	bne		m_normal
	lea		in_form,a0
	cmp.b	#$FF,(a0,d6.w)
	bne		m_normal

	lea		en_formx,a0
	move.w	d6,d2				;can't change d6
	lsl.w	#1,d2				;enemy number * 2
	move.w	(a0,d2.w),d3			;get current en_formx
	cmp.w	player+O_XPOS,d3		;compare to player position
	blt.b	.60
	sub.w	#1,d3				;move left
	bra.b	.70
.60:	add.w	#1,d3
.70:	move.w	d3,(a0,d2.w)			;save new en_formx value

	lea		en_formy,a0
	move.w	(a0,d2.w),d3			;get current en_formy
	cmp.w	player+O_YPOS,d3		;compare to player position
	blt.b	.75
	sub.w	#1,d3				;move up
	bra.b	.80
.75:	add.w	#1,d3
.80:	move.w	d3,(a0,d2.w)			;save new en_formy value

	bsr		m_useptb                        
	move.w	d1,O_XPOS(a1)
	move.w	d2,O_YPOS(a1)
.90:	rts

m_scrpsm::
;d6 = enemy counter
;a1 = enemy object header
;a2 = en_speed
;a3 = en_mvcnt
;a4 = en_mvlmt
;a5 = en_type

	tst.b	gameover				;game not over if 0
	beq.b	.30
	lea		en_usept,a0
	clr.b	(a0,d6.w)
	sub.w	#3,O_XPOS(a1)
	bpl.b	.90
	cmp.w	#-32,O_XPOS(a1)
	bge.b	.90
	bra		en_off				;turn off enemy if it reached its left limit
.30:
	tst.b	specweap+O_TYPE
	bmi.b	.50
	cmp.w	#MAGNET,specweap+O_DESC
	beq		m_tomag
.50:
	lea		en_usept,a0
	cmp.b	#1,(a0,d6.w)
	bne		m_normal
	lea		in_form,a0
	cmp.b	#$FF,(a0,d6.w)
	bne		m_normal

	lea		en_formx,a0
	move.w	d6,d2				;can't change d6
	lsl.w	#1,d2				;enemy number * 2
	move.w	(a0,d2.w),d3			;get current en_formx
	cmp.w	#(SCRN_RIGHT/2),d3		;compare to middle of screen
	blt.b	.60
	clr.w	d0
	move.b	(a2,d6.w),d0			;get enemy speed
	sub.w	d0,d3				;move left
.60:	move.w	d3,(a0,d2.w)			;save new en_formx value
	bsr		m_usept
	move.w	d1,O_XPOS(a1)
	move.w	d2,O_YPOS(a1)
.90:	rts

m_pill::
;d6 = enemy counter
;a1 = enemy object header
;a2 = en_speed
;a3 = en_mvcnt
;a4 = en_mvlmt
;a5 = en_type

	tst.b	gameover				;game not over if 0
	beq		.30
	lea		en_usept,a0
	clr.b	(a0,d6.w)
	sub.w	#2,O_XPOS(a1)
	bpl		.90
	cmp.w	#-16,O_XPOS(a1)
	bge		.90
	bra		en_off				;turn off enemy if it reached its left limit
.30:
	tst.b	specweap+O_TYPE
	bmi.b	.50
	cmp.w	#MAGNET,specweap+O_DESC
	beq		m_tomag
.50:
	lea		en_usept,a0
	cmp.b	#1,(a0,d6.w)
	bne		m_normal
	lea		in_form,a0
	cmp.b	#$FF,(a0,d6.w)
	bne		m_normal

	clr.w	d0
	move.b	(a2,d6.w),d0			;get enemy speed
	lea		en_formx,a0
	move.w	d6,d2				;can't change d6
	lsl.w	#1,d2				;enemy number * 2
	move.w	(a0,d2.w),d3			;get current en_formx
	move.w	d3,d1
	sub.w	player+O_XPOS,d1
	bpl.b	.52
	neg.w	d1					;get absolute value of distance
.52:	cmp.w	#5,d1
	blt.b	.62
	cmp.w	player+O_XPOS,d3
	blt.b	.55
	neg.w	d0					;add negative speed to move left
.55:	add.w	d0,d3
.60:	move.w	d3,(a0,d2.w)			;save new en_formx value
.62:
	clr.w	d0
	move.b	(a2,d6.w),d0			;get enemy speed
	lea		en_formy,a0
	move.w	(a0,d2.w),d3			;get current en_formy
	move.w	d3,d1
	sub.w	player+O_YPOS,d1
	bpl.b	.63
	neg.w	d1					;get absolute value of distance
.63:	cmp.w	#9,d1
	blt.b	.80
	cmp.w	player+O_YPOS,d3
	blt.b	.65
	neg.w	d0					;add negative speed to move up
.65:	add.w	d0,d3
.70:	move.w	d3,(a0,d2.w)			;save new en_formy value
.80:	bsr		m_usept
	move.w	d1,O_XPOS(a1)
	move.w	d2,O_YPOS(a1)
.90:	rts

m_bskull::
;d6 = enemy counter
;a1 = enemy object header
;a2 = en_speed
;a3 = en_mvcnt
;a4 = en_mvlmt
;a5 = en_type

	tst.b	gameover				;game not over if 0
	beq		.30
	lea		en_usept,a0
	clr.b	(a0,d6.w)
	sub.w	#3,O_XPOS(a1)
	bpl		.90
	cmp.w	#-48,O_XPOS(a1)
	bge		.90
	bra		en_off				;turn off enemy if it reached its left limit
.30:
	tst.b	specweap+O_TYPE
	bmi.b	.50
	cmp.w	#MAGNET,specweap+O_DESC
	beq		m_tomag
.50:
	lea		en_usept,a0
	cmp.b	#1,(a0,d6.w)
	bne		m_normal
	lea		in_form,a0
	cmp.b	#$FF,(a0,d6.w)
	bne		m_normal

	lea		en_formx,a0
	move.w	d6,d2				;can't change d6
	lsl.w	#1,d2				;enemy number * 2
	move.w	(a0,d2.w),d3			;get current en_formx
	clr.w	d0
	move.b	(a2,d6.w),d0			;get enemy speed
	sub.w	d0,d3				;move left
.60:	move.w	d3,(a0,d2.w)			;save new en_formx value

	cmp.w	#190,(a0,d2.w)			;check en_formx
	bge.b	.65
	lea		en_rad,a0
	add.w	#1,(a0,d2.w)
	bra.b	.70
.65:	lea		en_rad,a0
	cmp.w	#0,(a0,d2.w)
	beq.b	.70
	sub.w	#1,(a0,d2.w)
.70:
	bsr		m_usept
	move.w	d2,O_YPOS(a1)
	move.w	d1,O_XPOS(a1)
	tst.w	d1
	bpl.b	.90
	cmp.w	#-100,d1
	blt		en_off
.90:	rts

m_sphere::
;d6 = enemy counter
;a1 = enemy object header
;a2 = en_speed
;a3 = en_mvcnt
;a4 = en_mvlmt
;a5 = en_type

	tst.b	gameover				;game not over if 0
	beq.b	.30
	lea		en_usept,a0
	clr.b	(a0,d6.w)
	sub.w	#3,O_XPOS(a1)
	bpl.b	.90
	cmp.w	#-48,O_XPOS(a1)
	bge.b	.90
	bra		en_off				;turn off enemy if it reached its left limit
.30:
	tst.b	specweap+O_TYPE
	bmi.b	.50
	cmp.w	#MAGNET,specweap+O_DESC
	beq		m_tomag
.50:
	lea		en_usept,a0
	cmp.b	#1,(a0,d6.w)
	bne		m_normal

	lea		en_rad,a0
	move.w	d6,d2				;can't change d6
	lsl.w	#1,d2				;enemy number * 2
	cmp.w	#146,(a0,d2.w)			;minimum radius
	blt.b	.60
	clr.w	d0
	move.b	(a2,d6.w),d0			;get enemy speed
	sub.w	d0,(a0,d2.w)			;shrink radius
.60:
	bsr		m_usept
	move.w	d2,O_YPOS(a1)
	move.w	d1,O_XPOS(a1)
.90:	rts

m_tri::
;d6 = enemy counter
;a1 = enemy object header
;a2 = en_speed
;a3 = en_mvcnt
;a4 = en_mvlmt
;a5 = en_type

	tst.b	gameover				;game not over if 0
	beq.b	.30
	lea		en_usept,a0
	clr.b	(a0,d6.w)
	sub.w	#3,O_XPOS(a1)
	bpl.b	.90
	cmp.w	#-48,O_XPOS(a1)
	bge.b	.90
	bra		en_off				;turn off enemy if it reached its left limit
.30:
	tst.b	specweap+O_TYPE
	bmi.b	.50
	cmp.w	#MAGNET,specweap+O_DESC
	beq		m_tomag
.50:
	lea		en_usept,a0
	cmp.b	#1,(a0,d6.w)
	bne		m_normal
	lea		in_form,a0
	cmp.b	#$FF,(a0,d6.w)
	bne		m_normal

	lea		en_rad,a0
	move.w	d6,d2				;can't change d6
	lsl.w	#1,d2				;enemy number * 2
	cmp.w	#100,(a0,d2.w)			;minimum radius
	blt.b	.60
	clr.w	d0
	move.b	(a2,d6.w),d0			;get enemy speed
	sub.w	d0,(a0,d2.w)			;shrink radius
.60:
	bsr		m_useptb
	move.w	d2,O_YPOS(a1)
	move.w	d1,O_XPOS(a1)
.90:	rts



m_seym::
;d6 = enemy counter
;a1 = enemy object header
;a2 = en_speed
;a3 = en_mvcnt
;a4 = en_mvlmt
;a5 = en_type

	tst.b	gameover				;game not over if 0
	beq		.30
	lea		en_usept,a0
	clr.b	(a0,d6.w)
	sub.w	#3,O_XPOS(a1)
	bpl		.90
	cmp.w	#-64,O_XPOS(a1)
	bge.b	.90
	bra		en_off				;turn off enemy if it reached its left limit
.30:
	tst.b	specweap+O_TYPE
	bmi.b	.50
	cmp.w	#MAGNET,specweap+O_DESC
	beq		m_tomag
.50:
	lea		en_usept,a0
	cmp.b	#1,(a0,d6.w)
	bne		m_normal
	lea		in_form,a0
	cmp.b	#$FF,(a0,d6.w)
	bne		m_normal

	clr.w	d0
	move.b	(a2,d6.w),d0			;get enemy speed
	lea		en_formy,a0
	move.w	d6,d2				;can't change d6
	lsl.w	#1,d2				;enemy number * 2
	move.w	(a0,d2.w),d3			;get current en_formy
	move.w	d3,d1
	sub.w	player+O_YPOS,d1
	bpl.b	.52
	neg.w	d1
.52:	cmp.w	#10,d1
	blt.b	.80

	cmp.w	player+O_YPOS,d3
	blt.b	.55
	neg.w	d0
.55:	add.w	d0,d3
.60:	move.w	d3,(a0,d2.w)			;save new en_formy value
	move.w	d3,O_YPOS(a1)
.80:	bsr		m_usept
	move.w	d1,O_XPOS(a1)			;only use new X position
.90:	rts


m_buggy::
m_dinos::
m_ffly::
;d6 = enemy counter
;a1 = enemy object header
;a2 = en_speed
;a3 = en_mvcnt
;a4 = en_mvlmt
;a5 = en_type

	tst.b	specweap+O_TYPE
	bmi.b	.50
	cmp.w	#MAGNET,specweap+O_DESC
	beq		m_tomag
.50:
	lea		en_usept,a0
	cmp.b	#1,(a0,d6.w)
	bne		m_normal
	lea		in_form,a0
	cmp.b	#$FF,(a0,d6.w)
	bne		m_normal

	lea		en_formx,a0
	move.w	d6,d2				;can't change d6
	lsl.w	#1,d2				;enemy number * 2
	sub.w	#1,(a0,d2.w)			;move en_formx left 1
	bsr		m_usept
	move.w	d2,O_YPOS(a1)
	clr.w	d0
	move.b	(a2,d6.w),d0			;get speed of enemy
	sub.w	d0,O_XPOS(a1)			;just move left so it does a wave instead of a circle
	bpl.b	.90
	cmp.w	#-64,O_XPOS(a1)
	blt		en_off				;turn off enemy if it reached its left limit
.90:	rts

m_destop::
;d6 = enemy counter
;a1 = enemy object header
;a2 = en_speed
;a3 = en_mvcnt
;a4 = en_mvlmt
;a5 = en_type

	tst.b	gameover				;game not over if 0
	bne.b	.90					;don't move if game is over

	move.w	d6,d2				;can't change d6
	lsl.w	#1,d2				;enemy number * 2

	lea		en_rad,a0
	move.w	(a0,d2.w),d0			;get current radius
	lea		en_newrd,a6
	cmp.w	(a6,d2.w),d0
	bne.b	.25					;if radius is not at new radius value yet, keep adjusting it
	move.l	seed,d0				;get a new en_newrd value
	and.w	#$FF,d0				;0 - 255
	cmp.w	#176,d0
	blt.b	.20
	lsr.w	#1,d0
.20:
	add.w	#10,d0				;add minimum radius
	move.w	d0,(a6,d2.w)
	bra.b	.40
.25:	bcs.b	.30					;if current radius < new radius, add 1 to current radius
	sub.w	#1,d0				;subtract 1 from radius
	bra.b	.35
.30:	add.w	#1,d0				;add 1 to radius
.35:	move.w	d0,(a0,d2.w)			;save new radius value

.40:	lea		en_formx,a0
	move.w	(a0,d2.w),d3			;get current en_formx
	cmp.w	#190,d3				;compare to minimum xpos
	blt.b	.60
	clr.w	d0
	sub.w	#1,d3				;move left
.60:	move.w	d3,(a0,d2.w)			;save new en_formx value
	bsr		m_useptb
	move.w	d1,O_XPOS(a1)
	move.w	d2,O_YPOS(a1)
.90:	rts

m_quet::
;d6 = enemy counter
;a1 = enemy object header
;a2 = en_speed
;a3 = en_mvcnt
;a4 = en_mvlmt
;a5 = en_type

	tst.b	gameover				;game not over if 0
	bne.b	.90					;don't move if game is over

	move.w	d6,d2				;can't change d6
	lsl.w	#1,d2				;enemy number * 2

	lea		en_rad,a0
	move.w	(a0,d2.w),d0			;get current radius
	lea		en_newrd,a6
	cmp.w	(a6,d2.w),d0
	bne.b	.25					;if radius is not at new radius value yet, keep adjusting it
	move.l	seed,d0				;get a new en_newrd value
	and.w	#$FF,d0				;0 - 255
	cmp.w	#120,d0
	blt.b	.20
	lsr.w	#1,d0
.20:
	add.w	#6,d0				;add minimum radius
	move.w	d0,(a6,d2.w)
	bra.b	.40
.25:	bcs.b	.30					;if current radius < new radius, add 1 to current radius
	sub.w	#1,d0				;subtract 1 from radius
	bra.b	.35
.30:	add.w	#1,d0				;add 1 to radius
.35:	move.w	d0,(a0,d2.w)			;save new radius value

.40:	lea		en_formx,a0
	move.w	(a0,d2.w),d3			;get current en_formx
	cmp.w	#260,d3				;compare to minimum xpos
	blt.b	.60
	clr.w	d0
	sub.w	#1,d3				;move left
.60:	move.w	d3,(a0,d2.w)			;save new en_formx value
	bsr		m_useptb
	move.w	d1,O_XPOS(a1)
	move.w	d2,O_YPOS(a1)
.90:	rts

m_ctybod::
m_airrbt::
;d6 = enemy counter
;a1 = enemy object header
;a2 = en_speed
;a3 = en_mvcnt
;a4 = en_mvlmt
;a5 = en_type

	tst.b	gameover				;game not over if 0
	bne.b	.90					;don't move if game is over

	move.w	d6,d2				;can't change d6
	lsl.w	#1,d2				;enemy number * 2

	lea		en_rad,a0
	move.w	(a0,d2.w),d0			;get current radius
	lea		en_newrd,a6
	cmp.w	(a6,d2.w),d0
	bne.b	.25					;if radius is not at new radius value yet, keep adjusting it
	move.l	seed,d0				;get a new en_newrd value
	and.w	#$FF,d0				;0 - 255
	cmp.w	#135,d0
	blt.b	.20
	lsr.w	#1,d0
.20:
	add.w	#40,d0				;add minimum radius
	move.w	d0,(a6,d2.w)
	bra.b	.40
.25:	bcs.b	.30					;if current radius < new radius, add 1 to current radius
	sub.w	#1,d0				;subtract 1 from radius
	bra.b	.35
.30:	add.w	#1,d0				;add 1 to radius
.35:	move.w	d0,(a0,d2.w)			;save new radius value

.40:	lea		en_formx,a0
	move.w	(a0,d2.w),d3			;get current en_formx
	cmp.w	#238,d3				;compare to minimum xpos
	blt.b	.60
	clr.w	d0
	sub.w	#1,d3				;move left
.60:	move.w	d3,(a0,d2.w)			;save new en_formx value
	bsr		m_usept
	move.w	d1,O_XPOS(a1)
	move.w	d2,O_YPOS(a1)
.90:	rts

m_cvrbt::
;d6 = enemy counter
;a1 = enemy object header
;a2 = en_speed
;a3 = en_mvcnt
;a4 = en_mvlmt
;a5 = en_type

	tst.b	gameover				;game not over if 0
	bne.b	.90					;don't move if game is over

	move.w	d6,d2				;can't change d6
	lsl.w	#1,d2				;enemy number * 2

	lea		en_rad,a0
	move.w	(a0,d2.w),d0			;get current radius
	lea		en_newrd,a6
	cmp.w	(a6,d2.w),d0
	bne.b	.25					;if radius is not at new radius value yet, keep adjusting it
	move.l	seed,d0				;get a new en_newrd value
	and.w	#$FF,d0				;0 - 255
	cmp.w	#120,d0
	blt.b	.20
	lsr.w	#1,d0
.20:
	add.w	#20,d0				;add minimum radius
	move.w	d0,(a6,d2.w)
	bra.b	.40
.25:	bcs.b	.30					;if current radius < new radius, add 1 to current radius
	sub.w	#1,d0				;subtract 1 from radius
	bra.b	.35
.30:	add.w	#1,d0				;add 1 to radius
.35:	move.w	d0,(a0,d2.w)			;save new radius value

.40:	lea		en_formx,a0
	move.w	(a0,d2.w),d3			;get current en_formx
	cmp.w	#233,d3				;compare to minimum xpos
	blt.b	.60
	clr.w	d0
	sub.w	#1,d3				;move left
.60:	move.w	d3,(a0,d2.w)			;save new en_formx value
	bsr		m_usept
	move.w	d1,O_XPOS(a1)
	move.w	d2,O_YPOS(a1)
.90:	rts

m_serp::
m_wrdrbt::
;d6 = enemy counter
;a1 = enemy object header
;a2 = en_speed
;a3 = en_mvcnt
;a4 = en_mvlmt
;a5 = en_type

	tst.b	gameover				;game not over if 0
	bne.b	.90					;don't move if game is over

	move.w	d6,d2				;can't change d6
	lsl.w	#1,d2				;enemy number * 2

	lea		en_rad,a0
	move.w	(a0,d2.w),d0			;get current radius
	lea		en_newrd,a6
	cmp.w	(a6,d2.w),d0
	bne.b	.25					;if radius is not at new radius value yet, keep adjusting it
	move.l	seed,d0				;get a new en_newrd value
	and.w	#$FF,d0				;0 - 255
	cmp.w	#190,d0
	blt.b	.20
	lsr.w	#1,d0
.20:
	add.w	#10,d0				;add minimum radius
	move.w	d0,(a6,d2.w)
	bra.b	.40
.25:	bcs.b	.30					;if current radius < new radius, add 1 to current radius
	sub.w	#2,d0				;subtract 2 from radius
	bra.b	.35
.30:	add.w	#1,d0				;add 1 to radius
.35:	move.w	d0,(a0,d2.w)			;save new radius value

.40:	lea		en_formx,a0
	move.w	(a0,d2.w),d3			;get current en_formx
	cmp.w	#180,d3				;compare to minimum xpos
	blt.b	.60
	clr.w	d0
	sub.w	#1,d3				;move left
.60:	move.w	d3,(a0,d2.w)			;save new en_formx value
	bsr		m_usept
	move.w	d1,O_XPOS(a1)
	move.w	d2,O_YPOS(a1)
.90:	rts


m_normal::
;d6 = enemy counter
;a1 = enemy object header
;a2 = en_speed
;a3 = en_mvcnt
;a4 = en_mvlmt
;a5 = en_type

	move.w	d6,d0				;get enemy number
	lsl.w	#3,d0				;enemy number * 8 (limit table has 8 bytes for each enemy)
	lea		en_lim,a0
	move.w	(a0,d0.w),d2			;left limit
	move.w	2(a0,d0.w),d3			;right limit
	move.w	4(a0,d0.w),d4			;top limit
	move.w	6(a0,d0.w),d5			;bottom limit

	clr.l	d0
	move.b	(a2,d6.w),d0			;speed of enemy
.28:	lsl.w	#5,d0				;multiply speed * 16 directions for each speed * 2 bytes for each direction
	clr.l	d1
	lea		enemydir,a0
	move.b	(a0,d6.w),d1			;get enemy direction
	cmp.w	#0,scrlspd
	beq.b	.30					;if scrolling has stopped, no adjustment needed
	cmp.b	#8,d1				;see if direction is straight to the right
	bge.b	.30					;if down or right, no adjustment needed
	cmp.b	#0,d1
	beq.b	.30					;if straight up, no adjustment needed
	add.w	#64,d0				;increase speed 2 levels to make up for background scrolling if enemy is moving to the right
.30:	add.w	d1,d0				;add direction to speed * 32
	add.w	d1,d0				;add direction again because each direction uses 2 bytes

	bsr		move_obj
	tst.b	limitflag
	beq.b	.45					;did not reach limit if 0
	tst.w	O_DESC(a1)
	bpl.b	.40
.35:	or.b		#DELETE_OBJ,O_TYPE(a1)
	clr.w	O_DESC(a1)
	bra.b	.80

.40:	bsr		get_dir
	clr.b	(a3,d6.w)				;reset en_mvcnt when direction changes
	bra.b	.80

.45:	tst.w	O_DESC(a1)
	bmi.b	.80

	move.b	(a4,d6.w),d0			;get en_mvlmt for this enemy
	cmp.b	#$FF,d0
	beq.b	.80					;ignore limit if $FF
	lea		in_form,a0
	cmp.b	#$FF,(a0,d6.w)
	bne.b	.80					;don't use en_mvcnt if enemy is in formation
	add.b	#1,(a3,d6.w)			;increase en_mvcnt
	cmp.b	(a3,d6.w),d0			;compare en_mvcnt to en_mvlmt
	bne.b	.80					;change direction if at limit
	clr.b	(a3,d6.w)				;reset en_mvcnt when direction changes
	bsr		rnd_dir
	bsr		chg_spd
.80:	rts



old_move::
;d6 = enemy counter
;a1 = enemy object header
;a2 = en_speed
;a3 = en_mvcnt
;a4 = en_mvlmt
;a5 = en_type

	tst.b	gameover
	beq.b	.15					;game not over if 0
	lea		en_usept,a0
	clr.b	(a0,d6.w)
	lea		en_moves,a6
	move.w	(a5),d0
	lsl.w	#2,d0				;enemy type * 4
	cmp.b	#1,3(a6,d0.w)			;if 4th byte in table is 1, enemy should continue moving when game has ended
	bne		.80					;don't move this enemy when game is over

.15:
	tst.w	O_XPOS(a1)
	bpl.b	.20
	cmp.w	#-256,O_XPOS(a1)
	blt		en_off				;turn off enemy when way off screen

.20:
	move.w	d6,d0				;get enemy number
	lsl.w	#3,d0				;enemy number * 8 (limit table has 8 bytes for each enemy)
	lea		en_lim,a0
	move.w	(a0,d0.w),d2			;left limit
	move.w	2(a0,d0.w),d3			;right limit
	move.w	4(a0,d0.w),d4			;top limit
	move.w	6(a0,d0.w),d5			;bottom limit

	cmp.w	#FIRST_BOSS_ENEMY,(a5)
	bge.b	.22					;don't move ground enemies or boss enemies toward magnet
	tst.b	specweap+O_TYPE
	bmi.b	.22
	cmp.w	#MAGNET,specweap+O_DESC
	bne.b	.22
	bsr		m_tomag
	bra		.45

.22:	lea		en_usept,a6
	cmp.b	#1,(a6,d6.w)			;1 if enemy should use pattern
	beq		m_usept				;use pattern

.25:	clr.l	d0
	move.b	(a2,d6.w),d0			;speed of enemy
.28:	lsl.w	#5,d0				;multiply speed * 16 directions for each speed * 2 bytes for each direction
	clr.l	d1
	lea		enemydir,a0
	move.b	(a0,d6.w),d1			;get enemy direction
	cmp.w	#0,scrlspd
	beq.b	.30					;if scrolling has stopped, no adjustment needed
	cmp.b	#8,d1				;see if direction is straight to the right
	bge.b	.30					;if down or right, no adjustment needed
	cmp.b	#0,d1
	beq.b	.30					;if straight up, no adjustment needed
	add.w	#64,d0				;increase speed 2 levels to make up for background scrolling if enemy is moving to the right
.30:	add.w	d1,d0				;add direction to speed * 32
	add.w	d1,d0				;add direction again because each direction uses 2 bytes

	bsr		move_obj
	tst.w	O_DESC(a1)
	bmi.b	.80					;let explosion turn off when animation is done
	tst.b	limitflag
	beq.b	.45					;did not reach limit if 0

	bsr		get_dir
	clr.b	(a3,d6.w)				;reset en_mvcnt when direction changes
	bra.b	.80

.45:	tst.w	O_DESC(a1)
	bmi.b	.80

	move.b	(a4,d6.w),d0			;get en_mvlmt for this enemy
	cmp.b	#$FF,d0
	beq.b	.80					;ignore limit if $FF
	add.b	#1,(a3,d6.w)			;increase en_mvcnt
	cmp.b	(a3,d6.w),d0			;compare en_mvcnt to en_mvlmt
	bne.b	.80					;change direction if at limit
	clr.b	(a3,d6.w)				;reset en_mvcnt when direction changes
	bsr		rnd_dir
	bsr		chg_spd
.80:	rts

en_mvadr::
	dc.l	m_pill		;pillbug
	dc.l	m_seym		;seymour
	dc.l	m_rat		;turborat
	dc.l	m_bskull		;batskull
	dc.l	old_move		;big purple rock
	dc.l	old_move		;med purple rock
	dc.l	old_move		;sml purple rock
	dc.l	old_move		;big rock
	dc.l	old_move		;med rock
	dc.l	old_move		;sml rock
	dc.l	old_move		;big blue crystal
	dc.l	old_move		;med blue crystal A
	dc.l	old_move		;med blue crystal B
	dc.l	old_move		;big red star
	dc.l	old_move		;med red star
	dc.l	old_move		;spinner
	dc.l	m_scrpsm		;small scorpion
	dc.l	old_move		;big scorpion
	dc.l	m_buggy		;buggy
	dc.l	old_move		;cube
	dc.l	m_sphere		;sphere
	dc.l	m_tri		;tri 4 pieces
	dc.l	m_tri		;tri 3 pieces
	dc.l	m_tri		;tri 2 pieces
	dc.l	m_tri		;tri 1 piece
	dc.l	old_move		;bat
	dc.l	old_move		;big burple
	dc.l	old_move		;sml burple
	dc.l	old_move		;big bubble
	dc.l	old_move		;sml bubble
	dc.l	old_move		;big pebble
	dc.l	old_move		;med pebble
	dc.l	old_move		;sml pebble
	dc.l	m_fbug		;firebug
	dc.l	old_move		;hummingbird
	dc.l	m_vult		;vulture
	dc.l	old_move		;flower
	dc.l	old_move		;gundino
	dc.l	m_ffly		;firefly
	dc.l	old_move		;small spider
	dc.l	old_move		;big spider
	dc.l	old_move		;kilrun
	dc.l	old_move		;sadmask
	dc.l	old_move		;fish taxi
	dc.l	old_move		;baby
	dc.l	m_dinos		;small dino
	dc.l	old_move		;robot
	dc.l	old_move		;snake
	dc.l	old_move		;glowbug
	dc.l	old_move		;big blue eye
	dc.l	old_move		;big green eye
	dc.l	old_move		;small blue eye
	dc.l	old_move		;small green eye
	dc.l	old_move		;dragon
	dc.l	m_destop		;desert robot top
	dc.l	no_move		;desert robot bottom
	dc.l	m_airrbt		;air robot
	dc.l	m_cvrbt		;cave robot
	dc.l	m_wrdrbt		;weird robot body
	dc.l	no_move		;weird robot tail
	dc.l	no_move		;weird robot right arm
	dc.l	no_move		;weird robot left arm
	dc.l	m_ctybod		;city robot body
	dc.l	no_move		;city robot head
	dc.l	m_serp		;serpent body
	dc.l	no_move		;serpent right wing
	dc.l	no_move		;serpent left wing
	dc.l	m_quet		;quetzal body
	dc.l	no_move		;quetzal back arm
	dc.l	no_move		;quetzal front arm
	dc.l	no_move		;quetzal tail
	dc.l	m_wback		;skull ribs
	dc.l	no_move		;skull arm
	dc.l	no_move		;skull head
	dc.l	no_move		;skull neck
	dc.l	no_move		;skull back horn
	dc.l	no_move		;skull front horn
	dc.l	no_move		;skull nose horn
	dc.l	no_move		;oddit cloud
	dc.l	m_wback		;oddit
	dc.l	m_wback		;mud man
	dc.l	m_wback		;spore
	dc.l	m_wback		;fern
	dc.l	m_left		;big dino
	dc.l	m_left		;slug
	dc.l	old_move		;ball
	dc.l	m_left		;big block
	dc.l	m_left		;med block
	dc.l	m_left		;sml block
	dc.l	m_wback		;geyser
	dc.l	m_poppy		;poppy0
	dc.l	m_poppy		;poppy1
	dc.l	m_wback		;poppy2
	dc.l	m_wback		;tower
	dc.l	m_wback		;elec
	dc.l	old_move		;mingbot
	dc.l	m_fallrk		;falling rock
	dc.l	m_wback		;large ring
	dc.l	m_wback		;med ring
	dc.l	m_wback		;small ring


get_dir::							;enemy reached its X or Y limit
;a1 points to object that is moving
;d6 is enemy number
	movem.l	d1-d6/a1-a5,-(sp)
	clr.l	d2
	move.w	O_DESC(a1),d2				;get enemy type
	and.w	#$FF,d2
	tst.b	limitlf
	beq.b	.03
	lea		en_lf_lim,a3
	cmp.b	#1,(a3,d2.w)
	bne.b	.03
	bsr		en_off				;turn off enemy if it reached its left limit
	bra.b	.90
.03:	lea		dir_chg_table,a5		;what enemies do at edge of screen
	cmp.b	#0,(a5,d2.w)			;if 0, enemy disappears
	bne.b	.10
	bsr		en_off
	bra.b	.90

.10:	cmp.b	#1,(a5,d2.w)			;if 1, enemy changes to random opposite direction
	beq		.30					;get random dir

.20:	cmp.b	#2,(a5,d2.w)			;if 2, enemy gets new limits and changes to random direction
	bne.b	.50
	bsr		new_lmts
.30:	bsr		rnd_dir
	bra.b	.90

.50:	cmp.b	#3,(a5,d2.w)			;if 3, enemy changes to opposite direction
	bne.b	.90
	bsr		opp_dir
	bra.b	.90

.60:	cmp.b	#4,(a5,d2.w)			;if 4, enemy stops
	bne.b	.90
	lea		en_speed,a0
	clr.b	(a0,d6.w)				;set speed to 0
	bra.b	.90
.70:
	cmp.b	#5,(a5,d2.w)			;if 5, enemy changes to random opposite direction and gets new speed
	bne.b	.90
	bsr		rnd_dir
	bsr		chg_spd
.90:	movem.l	(sp)+,d1-d6/a1-a5
	rts

en_off::
	or.b		#DELETE_OBJ,O_TYPE(a1)	;turn off enemy
	clr.w	O_DESC(a1)
	rts

opp_dir::
	lea		enemydir,a0			;directions for each enemy
	add.b	#8,(a0,d6.w)			;add half of the total directions to current direction
	and.b	#15,(a0,d6.w)			;make sure new direction < total directions
	rts

new_lmts::
;set new limits for enemy
	move.w	d6,d0				;get enemy number
	lsl.w	#3,d0				;enemy number * 8
	lea		en_lim,a5
	move.w	O_XPOS(a1),(a5,d0.w)
	sub.w	#40,(a5,d0.w)			;new left limit is xpos - 40
	bmi.b	.20
	cmp.w	#10,(a5,d0.w)
	bge.b	.30					;branch if left limit is too low
.20:	move.w	#10,(a5,d0.w)			;set minimum left limit
.30:	move.w	O_XPOS(a1),2(a5,d0.w)
	add.w	#40,2(a5,d0.w)			;new right limit is xpos + 40
	cmp.w	#SCRN_RIGHT-54,2(a5,d0.w)
	bcs.b	.40					;branch if right limit < SCRN_RIGHT - 16
	move.w	#SCRN_RIGHT-54,2(a5,d0.w)	;set maximum right limit
.40:	move.w	O_YPOS(a1),4(a5,d0.w)
	sub.w	#70,4(a5,d0.w)			;new top limit is ypos - 70
	cmp.w	#SCRN_TOP,4(a5,d0.w)
	bcs.b	.50					;branch if top limit < SCRN_TOP
	move.w	#SCRN_TOP,4(a5,d0.w)	;set minimum top limit
.50:	move.w	O_YPOS(a1),6(a5,d0.w)
	add.w	#70,6(a5,d0.w)			;new bottom limit is ypos + 70
	cmp.w	#SCRN_BOTTOM-100,6(a5,d0.w)
	bcs.b	.90					;branch if bottom limit < SCRN_BOTTOM - 20
	move.w	#SCRN_BOTTOM-100,6(a5,d0.w)	;set maximum bottom limit
.90:	rts

rnd_dir::
;get random direction for enemy
	bsr		random
	and.l	#3,d0				;0 - 3
	sub.b	#2,d0				;change it to -2 to 1
	add.b	#8,d0				;add opposite direction
	lea		enemydir,a0			;table of directions for each enemy
	add.b	(a0,d6.w),d0			;add current direction to 6,7,8,or 9 to get a random opposite direction
	and.b	#15,d0				;make sure direction is 0 - 15
	move.b	d0,(a0,d6.w)			;save new direction for this enemy
	rts

chg_spd::
;change speed of enemy
	move.l	seed+12,d0
	and.w	#7,d0				;8 possible speeds for each enemy type
	move.w	O_DESC(a1),d1			;get enemy type
	lsl.w	#3,d1				;enemy type * 8
	add.w	d1,d0				;add enemy type * 8 to random 0-7
	lea		en_spd_table,a0
	lea		en_speed,a6
	move.b	(a0,d0.w),(a6,d6.w)		;save new speed for current enemy
	rts


do_wave::
;D1 = formx (en_formx)
;D2 = formy (en_formy)
;D3 = pattern counter (en_formc)
;D4 = radius (en_rad)
;D5 = theta (en_theta)
;D6 = enemy number (not used, but must be preserved)

;when this is finished
;D1 = new X position
;D2 = new Y position

	movem.l	d6/a0,-(sp)

	moveq.l	#14,d7			;for shifting result of multiplication
;X
	mulu		d5,d3			;en_theta * en_formc
	move.w	d3,d0			;result of theta * pattern counter
	bsr		cos
	muls.w	d4,d0			;en_rad * cos 0
	lsr.l	d7,d0			;shift right 14 bits
	add.w	d0,d1			;add result to en_formx, leave new X position in D1
;Y
	move.w	d3,d0			;d3 is already en_formc * en_theta
	bsr		sin
	muls.w	d4,d0			;en_rad * sin 0
	lsr.l	d7,d0			;shift right 14 bits
	add.w	d0,d2			;add result to en_formy, leave new Y position in D2
	movem.l	(sp)+,d6/a0
	rts
cos:
	add.w	#512,d0
sin:
	move.w	d0,d6	; keep quadrant data in d6 (make sure d6 gets restored to enemy number at rts)
	and.w	#511,d0	; strip quadrant data in d0
	btst		#9,d6
	beq.b	.10
	neg.w	d0
	add.w	#512,d0
.10:
	move.l	#sn,a0		; LUT base address
	asl.w	#1,d0		; word offset
	move.w	(a0,d0.w),d0
	btst		#10,d6
	beq.b	.50
	neg.l	d0
.50:	rts

;--------------------------------------------------------------------
; Quarter-wave sin table
sn::
	dc.w  $0000, $0032, $0064, $0096, $00c9, $00fb, $012d, $015f
	dc.w  $0192, $01c4, $01f6, $0228, $025b, $028d, $02bf, $02f1
	dc.w  $0323, $0356, $0388, $03ba, $03ec, $041e, $0451, $0483
	dc.w  $04b5, $04e7, $0519, $054b, $057d, $05af, $05e1, $0613
	dc.w  $0645, $0677, $06a9, $06db, $070d, $073f, $0771, $07a3
	dc.w  $07d5, $0807, $0839, $086b, $089c, $08ce, $0900, $0932
	dc.w  $0964, $0995, $09c7, $09f9, $0a2a, $0a5c, $0a8d, $0abf
	dc.w  $0af1, $0b22, $0b54, $0b85, $0bb6, $0be8, $0c19, $0c4b
	dc.w  $0c7c, $0cad, $0cde, $0d10, $0d41, $0d72, $0da3, $0dd4
	dc.w  $0e05, $0e36, $0e67, $0e98, $0ec9, $0efa, $0f2b, $0f5c
	dc.w  $0f8c, $0fbd, $0fee, $101f, $104f, $1080, $10b0, $10e1
	dc.w  $1111, $1142, $1172, $11a2, $11d3, $1203, $1233, $1263
	dc.w  $1294, $12c4, $12f4, $1324, $1354, $1383, $13b3, $13e3
	dc.w  $1413, $1443, $1472, $14a2, $14d1, $1501, $1530, $1560
	dc.w  $158f, $15be, $15ee, $161d, $164c, $167b, $16aa, $16d9
	dc.w  $1708, $1737, $1766, $1794, $17c3, $17f2, $1820, $184f
	dc.w  $187d, $18ac, $18da, $1908, $1937, $1965, $1993, $19c1
	dc.w  $19ef, $1a1d, $1a4b, $1a79, $1aa6, $1ad4, $1b02, $1b2f
	dc.w  $1b5d, $1b8a, $1bb7, $1be5, $1c12, $1c3f, $1c6c, $1c99
	dc.w  $1cc6, $1cf3, $1d20, $1d4c, $1d79, $1da6, $1dd2, $1dfe
	dc.w  $1e2b, $1e57, $1e83, $1eb0, $1edc, $1f08, $1f34, $1f5f
	dc.w  $1f8b, $1fb7, $1fe2, $200e, $2039, $2065, $2090, $20bb
	dc.w  $20e7, $2112, $213d, $2168, $2192, $21bd, $21e8, $2212
	dc.w  $223d, $2267, $2292, $22bc, $22e6, $2310, $233a, $2364
	dc.w  $238e, $23b8, $23e1, $240b, $2434, $245e, $2487, $24b0
	dc.w  $24da, $2503, $252c, $2554, $257d, $25a6, $25cf, $25f7
	dc.w  $261f, $2648, $2670, $2698, $26c0, $26e8, $2710, $2738
	dc.w  $275f, $2787, $27af, $27d6, $27fd, $2824, $284b, $2872
	dc.w  $2899, $28c0, $28e7, $290e, $2934, $295a, $2981, $29a7
	dc.w  $29cd, $29f3, $2a19, $2a3f, $2a65, $2a8a, $2ab0, $2ad5
	dc.w  $2afa, $2b20, $2b45, $2b6a, $2b8e, $2bb3, $2bd8, $2bfc
	dc.w  $2c21, $2c45, $2c6a, $2c8e, $2cb2, $2cd6, $2cf9, $2d1d
	dc.w  $2d41, $2d64, $2d88, $2dab, $2dce, $2df1, $2e14, $2e37
	dc.w  $2e5a, $2e7c, $2e9f, $2ec1, $2ee3, $2f05, $2f28, $2f49
	dc.w  $2f6b, $2f8d, $2faf, $2fd0, $2ff1, $3013, $3034, $3055
	dc.w  $3076, $3096, $30b7, $30d8, $30f8, $3118, $3138, $3159
	dc.w  $3179, $3198, $31b8, $31d8, $31f7, $3216, $3236, $3255
	dc.w  $3274, $3293, $32b1, $32d0, $32ee, $330d, $332b, $3349
	dc.w  $3367, $3385, $33a3, $33c1, $33de, $33fb, $3419, $3436
	dc.w  $3453, $3470, $348c, $34a9, $34c6, $34e2, $34fe, $351a
	dc.w  $3536, $3552, $356e, $3589, $35a5, $35c0, $35dc, $35f7
	dc.w  $3612, $362c, $3647, $3662, $367c, $3696, $36b1, $36cb
	dc.w  $36e5, $36fe, $3718, $3731, $374b, $3764, $377d, $3796
	dc.w  $37af, $37c8, $37e0, $37f9, $3811, $3829, $3841, $3859
	dc.w  $3871, $3889, $38a0, $38b7, $38cf, $38e6, $38fd, $3913
	dc.w  $392a, $3941, $3957, $396d, $3983, $3999, $39af, $39c5
	dc.w  $39da, $39f0, $3a05, $3a1a, $3a2f, $3a44, $3a59, $3a6d
	dc.w  $3a82, $3a96, $3aaa, $3abe, $3ad2, $3ae6, $3afa, $3b0d
	dc.w  $3b20, $3b34, $3b47, $3b59, $3b6c, $3b7f, $3b91, $3ba3
	dc.w  $3bb6, $3bc8, $3bda, $3beb, $3bfd, $3c0e, $3c20, $3c31
	dc.w  $3c42, $3c53, $3c63, $3c74, $3c84, $3c95, $3ca5, $3cb5
	dc.w  $3cc5, $3cd4, $3ce4, $3cf3, $3d02, $3d12, $3d21, $3d2f
	dc.w  $3d3e, $3d4d, $3d5b, $3d69, $3d77, $3d85, $3d93, $3da1
	dc.w  $3dae, $3dbb, $3dc9, $3dd6, $3de2, $3def, $3dfc, $3e08
	dc.w  $3e14, $3e21, $3e2d, $3e38, $3e44, $3e50, $3e5b, $3e66
	dc.w  $3e71, $3e7c, $3e87, $3e92, $3e9c, $3ea7, $3eb1, $3ebb
	dc.w  $3ec5, $3ece, $3ed8, $3ee1, $3eeb, $3ef4, $3efd, $3f06
	dc.w  $3f0e, $3f17, $3f1f, $3f27, $3f2f, $3f37, $3f3f, $3f47
	dc.w  $3f4e, $3f55, $3f5d, $3f64, $3f6a, $3f71, $3f78, $3f7e
	dc.w  $3f84, $3f8a, $3f90, $3f96, $3f9c, $3fa1, $3fa6, $3fac
	dc.w  $3fb1, $3fb5, $3fba, $3fbf, $3fc3, $3fc7, $3fcb, $3fcf
	dc.w  $3fd3, $3fd7, $3fda, $3fde, $3fe1, $3fe4, $3fe7, $3fe9
	dc.w  $3fec, $3fee, $3ff0, $3ff2, $3ff4, $3ff6, $3ff8, $3ff9
	dc.w  $3ffb, $3ffc, $3ffd, $3ffe, $3ffe, $3fff, $3fff, $3fff
	dc.w  $4000

